

//////////////////////////////////////////////////////////////////////////////
//
// Misc
//
//////////////////////////////////////////////////////////////////////////////

Geo* GetCanyon();
Geo* GetRight();
Geo* GetStraight();

//////////////////////////////////////////////////////////////////////////////
//
// TerrainGeo
//
//////////////////////////////////////////////////////////////////////////////

class TerrainGeo : public WrapGeo
{
public:
    TerrainGeo() : WrapGeo(Geo::GetEmpty())
    {
    }
};


//////////////////////////////////////////////////////////////////////////////
//
// TerrainTileData
//
//////////////////////////////////////////////////////////////////////////////

class TerrainTileData : public IObject
{
public:
    virtual int GetNumConnections() = 0;
    virtual const Matrix& GetConnectionMatrix(int iConnection) = 0;
    static TRef<TerrainTileData> Create(Geo* pgeoTile);
};

//////////////////////////////////////////////////////////////////////////////
//
// TerrainTile
//
//////////////////////////////////////////////////////////////////////////////

class TerrainTile : public IObject
{
public:
};


//////////////////////////////////////////////////////////////////////////////
//
// TerrainMap
//
//////////////////////////////////////////////////////////////////////////////

class TerrainMap : public IObject
{
public:
    virtual bool HitTest(const Vector& posWorld) = 0;
    virtual TRef<TerrainTile> CreateTile(TerrainTileData* ptileData) = 0;
    virtual TRef<TerrainTile> Connect(TerrainTile* ptileSrc, int iConnectionSrc, TerrainTile* ptileDest) = 0;
    virtual TRef<TerrainTile> SetRoot(TerrainTile* ptile) = 0;

    virtual TRef<TerrainGeo> GetGeo() = 0;
    static TRef<TerrainMap> Create();
};



