//////////////////////////////////////////////////////////////////////////////
//
// Project
//
//////////////////////////////////////////////////////////////////////////////

#include "pch.h"

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class Symbol : public IObject {
private:
    ZString    m_strName;

public:
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class Type : public Symbol {
private:
public:
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class Class : public Type {
private:
    TRef<Class>   m_pclassOwner;
    TList<Class>  m_listParents;
    TList<Symbol> m_listSymbols;

public:
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class FunctionType : public Type {
private:
    TRef<Type>  m_ptypeResult;
    TList<Type> m_listTypeFormalArguments;

public:
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class Data : public IObject {
private:
public:
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class Member : public Symbol {
private:
    enum Access {
        MemberPublic,
        MemberProtected,
        MemberPrivate
    };

    TRef<Type>  m_ptype;
    TRef<Data>  m_pdata;

    Access      m_access;
    bool        m_bConstant;
    bool        m_bStatic;

public:
    Member(Type* ptype) :
        m_access(MemberPrivate),
        m_bConstant(false),
        m_bStatic(false),
        m_ptype(ptype),
        m_pdata(Data::GetEmpty())
    {
    }

    Access GetAcsess()   { return m_access;    }
    bool   GetConstant() { return m_bConstant; }
    bool   GetStatic()   { return m_bStatic;   }

    void SetAccess(Access access)    { m_access    = access;    }
    void SetConstant(bool bConstant) { m_bConstant = bConstant; }
    void SetStatic(bool bStatic)     { m_bStatic   = bStatic;   }
};

//////////////////////////////////////////////////////////////////////////////
//
// expression
// jumps
//     break
//     continue
//     return
//     goto
// blocks
//     block
//     if
//     while
//     do
// switch
//
//////////////////////////////////////////////////////////////////////////////

class Statement : public IObject {
private:
    Block* m_blockOwner;

public:
};

//////////////////////////////////////////////////////////////////////////////
//
// infix    + * - / & && | || ^ , == != < <= > >= = -= *= /= += &= |= ^= >> << >>= <<=
// prefix   * & - ~ -- ++
// postfix  -- ++
// apply    expr(args)
// array    expr[expr]
// member   expr.name
// indirect expr->name
// cast     (type)expr
// new      new Type(args)[expr]
// delete   delete expr
// terminal name
// value    1 0.4f "string" 'c'
//
//////////////////////////////////////////////////////////////////////////////

class Expression : public Statement {
private:
public:
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class Return : public Statement {
private:
    TRef<Expression> m_pexpression;

public:
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class Break : public Statement {
private:
public:
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class Continue : public Statement {
private:
public:
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class IfBlock : public Statement {
private:
    TRef<Expression> m_pexpression;
    TRef<Block>      m_pblock;

public:
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class WhileBlock : public Statement {
private:
    TRef<Expression> m_pexpression;
    TRef<Block>      m_pblock;

public:
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class DoBlock : public Statement {
private:
    TRef<Expression> m_pexpression;
    TRef<Block>      m_pblock;

public:
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class SwitchBlock : public Statement {
private:
    class Case {
    public:
        TRef<Expression> m_pexpression;
        TRef<Block>      m_pblock;
    };

    TRef<Expression> m_pexpression;
    TList<Case>      m_listCases;

public:
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class Block : public Statement {
private:
public:
    //
    // Declaration
    //

    TList<Member>    m_listMembers;

    TList<Statement> m_listStatements;
};

//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

class Project : public IObject {
private:
public:
};
