/////////////////////////////////////////////////////////////////////////////
// Pigs.cpp : Implementation of the CPigs class.

#include "pch.h"
#include <TCLib.h>
#include <..\TCAtl\ObjectMap.h>

#include "Pigs.h"


/////////////////////////////////////////////////////////////////////////////
// CPigs

TC_OBJECT_EXTERN_NON_CREATEABLE_IMPL(CPigs)


/////////////////////////////////////////////////////////////////////////////
// Construction / Destruction

CPigs::CPigs()
{
}

HRESULT CPigs::FinalConstruct()
{
  // Indicate success
  return S_OK;
}

void CPigs::FinalRelease()
{
}


/////////////////////////////////////////////////////////////////////////////
// Operations

void CPigs::AddPig(DWORD dwGITCookie, _bstr_t bstrName)
{
  XLock lock(this);

  // Ensure that the specified pig is not already in either collection
  assert(m_mapByCookie.end() == m_mapByCookie.find(dwGITCookie));
  assert(m_mapByName.end() == m_mapByName.find(bstrName));

  // Add the association to the collections
  m_mapByCookie.insert(std::make_pair(dwGITCookie, bstrName));
  m_mapByName.insert(std::make_pair(bstrName, dwGITCookie));
}

void CPigs::RemovePig(DWORD dwGITCookie)
{
  XLock lock(this);

  // Find the specified pig in the collection
  XMapByCookieIt itCookie = m_mapByCookie.find(dwGITCookie);
  assert(m_mapByCookie.end() != itCookie);

  // Find the associated name in the other collection
  XMapByNameIt itName = m_mapByName.find(itCookie->second);
  assert(m_mapByName.end() != itName);
  assert(itCookie->first == itName->second);

  // Remove the pig from both collections
  m_mapByCookie.erase(itCookie);
  m_mapByName.erase(itName);
}

void CPigs::RenamePig(DWORD dwGITCookie, _bstr_t bstrName)
{
  XLock lock(this);

  // Find the specified pig in the collection
  XMapByCookieIt itCookie = m_mapByCookie.find(dwGITCookie);
  assert(m_mapByCookie.end() != itCookie);

  // Find the pig's old name in the other collection
  XMapByNameIt itName = m_mapByName.find(itCookie->second);
  assert(m_mapByName.end() != itName);
  assert(itCookie->first == itName->second);

  // Remove the pig from the 'by name' collection
  m_mapByName.erase(itName);

  // Add the new association to the 'by name' collection
  m_mapByName.insert(std::make_pair(bstrName, dwGITCookie));

  // Change the value of in the 'by cookie' collection
  itCookie->second = bstrName;
}


/////////////////////////////////////////////////////////////////////////////
// Implementation


/////////////////////////////////////////////////////////////////////////////
// ISupportErrorInfo Interface Methods

STDMETHODIMP CPigs::InterfaceSupportsErrorInfo(REFIID riid)
{
  static const IID* arr[] = 
  {
    &IID_IPigs,
  };
  for (int i = 0; i < sizeofArray(arr); ++i)
  {
    if (InlineIsEqualGUID(*arr[i], riid))
      return S_OK;
  }
  return S_FALSE;
}


/////////////////////////////////////////////////////////////////////////////
// ITCCollection Interface Methods

STDMETHODIMP CPigs::get_Count(long* pnCount)
{
  XLock lock(this);

  assert(m_mapByCookie.size() == m_mapByName.size());
  CLEAROUT(pnCount, (long)m_mapByCookie.size());
  return S_OK;
}

STDMETHODIMP CPigs::get__NewEnum(IUnknown** ppunkEnum)
{
  // Clear the [out] parameter
  CLEAROUT(ppunkEnum, (IUnknown*)NULL);

  // Lock this object for the duration of the copy operation
  XLock lock(this);

  // Copy the elements of 'by name' map to a temporary CComVariant vector
  assert(m_mapByCookie.size() == m_mapByName.size());
  CComVariant var;
  std::vector<CComVariant> vecTemp(m_mapByName.size(), CComVariant());
  std::vector<CComVariant>::iterator itVec = vecTemp.begin();
  for (XMapByNameIt it = m_mapByName.begin(); it != m_mapByName.end(); ++it)
  {
    // Get an apartment-safe interface pointer for the located object
    IPigPtr spPig;
    RETURN_FAILED(GetEngine().GetInterfaceFromGlobal(it->second,
      IID_IPig, (void**)&spPig));

    // Initialize the variant with the IUnknown pointer
    var = (IDispatch*)spPig;

    // Place it into the pre-created slot of the temporary vector
    *itVec++ = var;
  }

  // Unlock the object after the copy
  lock.Unlock();

  // Create a new CComEnum enumerator object
  typedef CComObject<CComEnum<IEnumVARIANT, &IID_IEnumVARIANT, VARIANT,
    _Copy<VARIANT> > > CEnum;
  CEnum* pEnum = new CEnum;
  assert(NULL != pEnum);

  // Initialize enumerator object with the temporary CComVariant vector
  HRESULT hr = pEnum->Init(vecTemp.begin(), vecTemp.end(), NULL, AtlFlagCopy);
  if (SUCCEEDED(hr))
    hr = pEnum->QueryInterface(IID_IEnumVARIANT, (void**)ppunkEnum);
  if (FAILED(hr))
    delete pEnum;

  // Return the last result
  return hr;
}


/////////////////////////////////////////////////////////////////////////////
// IPigs Interface Methods

HRESULT CPigs::get_Item(VARIANT* pvIndex, IPig** ppPig)
{
  assert(m_mapByCookie.size() == m_mapByName.size());

  // Initialize the [out] parameter
  CLEAROUT(ppPig, (IPig*)NULL);

  // Ensure that the specified index is a VT_BSTR
  if (VT_BSTR != V_VT(pvIndex))
    return DISP_E_TYPEMISMATCH;

  // Lookup the specified name in the 'by name' map
  DWORD dwGIT = Find(V_BSTR(pvIndex));
  if (!dwGIT)
    return S_FALSE;

  // Get an apartment-safe interface pointer for the located object
  return GetEngine().GetInterfaceFromGlobal(dwGIT, IID_IPig, (void**)ppPig);
}

