/////////////////////////////////////////////////////////////////////////////
// Entry point simply calls the main function.

try
{
  main(WScript.Arguments, WScript.Arguments.Count());
}
catch(e)
{
  WScript.Echo("ERROR: \"" + e.description + "\"");
}


/////////////////////////////////////////////////////////////////////////////
// Description: Parses the command line parameters and validates the usage.
//
function main(args, cArgs)
{
  // Validate the command line arguments
  if (cArgs > 1)
    return Syntax();
  var bDisable = false;
  if (cArgs)
  {
    if ("-?" == args(0) || "/?" == args(0))
      return Syntax();
    if ("off" == args(0).toLowerCase())
      bDisable = true;
    else
      return Syntax();
  }

  // Connect to the AllSrv object model
  var objSession = new ActiveXObject("AllSrv.AdminSession");

  // Get the EventLog property
  var objEventLog = objSession.EventLog;

  // Create an all-inclusive (or all-exclusive) range of events
  var objRanges = new ActiveXObject("AGC.EventIDRanges");
  if (!bDisable)
    objRanges.AddByValues(0, 0x7FFFFFFF);

  // Enable/disable database logging of all events that the server fires
  objEventLog.EnabledDBEvents = objRanges;

  // Format the response message
  var str;
  if (bDisable)
    str = "No events generated by AllSrv will be logged to the database.";
  else
    str = "All events generated by AllSrv will now be logged to the database.";

  // Display the response message
  WScript.Echo(str);
}


/////////////////////////////////////////////////////////////////////////////
// Displays the usage syntax of this script
//
function Syntax()
{
  var str =
    "\nEnables/disables the logging of all AllSrv events to the current\n"
    + "database log, if any.\n\n"
    + "Usage:\n\n"
    + "  LogAllEvents\n"
    + "  LogAllEvents off\n\n"
    // ----+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8
    + "When no parameter is specified, all events generated by AllSrv will be logged\n"
    + "to the database event log, if any.\n\n"
    + "When the OFF parameters is specified, no events generated by AllSrv will be\n"
    + "logged to the database event log.";
  WScript.Echo(str);
}



